<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/enums/v1/deployment.proto

namespace Temporal\Api\Enums\V1;

use UnexpectedValueException;

/**
 * Versioning Mode of a worker is set by the app developer in the worker code, and specifies the
 * behavior of the system in the following related aspects:
 * - Whether or not Temporal Server considers this worker's version (Build ID) when dispatching
 *   tasks to it.
 * - Whether or not the workflows processed by this worker are versioned using the worker's version.
 * Experimental. Worker Deployments are experimental and might significantly change in the future.
 *
 * Protobuf type <code>temporal.api.enums.v1.WorkerVersioningMode</code>
 */
class WorkerVersioningMode
{
    /**
     * Generated from protobuf enum <code>WORKER_VERSIONING_MODE_UNSPECIFIED = 0;</code>
     */
    const WORKER_VERSIONING_MODE_UNSPECIFIED = 0;
    /**
     * Workers with this mode are not distinguished from each other for task routing, even if they
     * have different Build IDs.
     * Workflows processed by this worker will be unversioned and user needs to use Patching to keep
     * the new code compatible with prior versions.
     * This mode is recommended to be used along with Rolling Upgrade deployment strategies.
     * Workers with this mode are represented by the special string `__unversioned__` in the APIs.
     *
     * Generated from protobuf enum <code>WORKER_VERSIONING_MODE_UNVERSIONED = 1;</code>
     */
    const WORKER_VERSIONING_MODE_UNVERSIONED = 1;
    /**
     * Workers with this mode are part of a Worker Deployment Version which is identified as
     * "<deployment_name>.<build_id>". Such workers are called "versioned" as opposed to
     * "unversioned".
     * Each Deployment Version is distinguished from other Versions for task routing and users can
     * configure Temporal Server to send tasks to a particular Version (see
     * `WorkerDeploymentInfo.routing_config`). This mode is the best option for Blue/Green and
     * Rainbow strategies (but typically not suitable for Rolling upgrades.)
     * Workflow Versioning Behaviors are enabled in this mode: each workflow type must choose
     * between the Pinned and AutoUpgrade behaviors. Depending on the chosen behavior, the user may
     * or may not need to use Patching to keep the new code compatible with prior versions. (see
     * VersioningBehavior enum.)
     *
     * Generated from protobuf enum <code>WORKER_VERSIONING_MODE_VERSIONED = 2;</code>
     */
    const WORKER_VERSIONING_MODE_VERSIONED = 2;

    private static $valueToName = [
        self::WORKER_VERSIONING_MODE_UNSPECIFIED => 'WORKER_VERSIONING_MODE_UNSPECIFIED',
        self::WORKER_VERSIONING_MODE_UNVERSIONED => 'WORKER_VERSIONING_MODE_UNVERSIONED',
        self::WORKER_VERSIONING_MODE_VERSIONED => 'WORKER_VERSIONING_MODE_VERSIONED',
    ];

    public static function name($value)
    {
        if (!isset(self::$valueToName[$value])) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no name defined for value %s', __CLASS__, $value));
        }
        return self::$valueToName[$value];
    }


    public static function value($name)
    {
        $const = __CLASS__ . '::' . strtoupper($name);
        if (!defined($const)) {
            throw new UnexpectedValueException(sprintf(
                    'Enum %s has no value defined for name %s', __CLASS__, $name));
        }
        return constant($const);
    }
}

