<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/history/v1/message.proto

namespace Temporal\Api\History\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * Event marking that an operation was scheduled by a workflow via the ScheduleNexusOperation command.
 *
 * Generated from protobuf message <code>temporal.api.history.v1.NexusOperationScheduledEventAttributes</code>
 */
class NexusOperationScheduledEventAttributes extends \Google\Protobuf\Internal\Message
{
    /**
     * Endpoint name, must exist in the endpoint registry.
     *
     * Generated from protobuf field <code>string endpoint = 1;</code>
     */
    protected $endpoint = '';
    /**
     * Service name.
     *
     * Generated from protobuf field <code>string service = 2;</code>
     */
    protected $service = '';
    /**
     * Operation name.
     *
     * Generated from protobuf field <code>string operation = 3;</code>
     */
    protected $operation = '';
    /**
     * Input for the operation. The server converts this into Nexus request content and the appropriate content headers
     * internally when sending the StartOperation request. On the handler side, if it is also backed by Temporal, the
     * content is transformed back to the original Payload stored in this event.
     *
     * Generated from protobuf field <code>.temporal.api.common.v1.Payload input = 4;</code>
     */
    protected $input = null;
    /**
     * Schedule-to-close timeout for this operation.
     * Indicates how long the caller is willing to wait for operation completion.
     * Calls are retried internally by the server.
     * (-- api-linter: core::0140::prepositions=disabled
     *     aip.dev/not-precedent: "to" is used to indicate interval. --)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration schedule_to_close_timeout = 5;</code>
     */
    protected $schedule_to_close_timeout = null;
    /**
     * Header to attach to the Nexus request. Note these headers are not the same as Temporal headers on internal
     * activities and child workflows, these are transmitted to Nexus operations that may be external and are not
     * traditional payloads.
     *
     * Generated from protobuf field <code>map<string, string> nexus_header = 6;</code>
     */
    private $nexus_header;
    /**
     * The `WORKFLOW_TASK_COMPLETED` event that the corresponding ScheduleNexusOperation command was reported with.
     *
     * Generated from protobuf field <code>int64 workflow_task_completed_event_id = 7;</code>
     */
    protected $workflow_task_completed_event_id = 0;
    /**
     * A unique ID generated by the history service upon creation of this event.
     * The ID will be transmitted with all nexus StartOperation requests and is used as an idempotentency key.
     *
     * Generated from protobuf field <code>string request_id = 8;</code>
     */
    protected $request_id = '';
    /**
     * Endpoint ID as resolved in the endpoint registry at the time this event was generated.
     * This is stored on the event and used internally by the server in case the endpoint is renamed from the time the
     * event was originally scheduled.
     *
     * Generated from protobuf field <code>string endpoint_id = 9;</code>
     */
    protected $endpoint_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $endpoint
     *           Endpoint name, must exist in the endpoint registry.
     *     @type string $service
     *           Service name.
     *     @type string $operation
     *           Operation name.
     *     @type \Temporal\Api\Common\V1\Payload $input
     *           Input for the operation. The server converts this into Nexus request content and the appropriate content headers
     *           internally when sending the StartOperation request. On the handler side, if it is also backed by Temporal, the
     *           content is transformed back to the original Payload stored in this event.
     *     @type \Google\Protobuf\Duration $schedule_to_close_timeout
     *           Schedule-to-close timeout for this operation.
     *           Indicates how long the caller is willing to wait for operation completion.
     *           Calls are retried internally by the server.
     *           (-- api-linter: core::0140::prepositions=disabled
     *               aip.dev/not-precedent: "to" is used to indicate interval. --)
     *     @type array|\Google\Protobuf\Internal\MapField $nexus_header
     *           Header to attach to the Nexus request. Note these headers are not the same as Temporal headers on internal
     *           activities and child workflows, these are transmitted to Nexus operations that may be external and are not
     *           traditional payloads.
     *     @type int|string $workflow_task_completed_event_id
     *           The `WORKFLOW_TASK_COMPLETED` event that the corresponding ScheduleNexusOperation command was reported with.
     *     @type string $request_id
     *           A unique ID generated by the history service upon creation of this event.
     *           The ID will be transmitted with all nexus StartOperation requests and is used as an idempotentency key.
     *     @type string $endpoint_id
     *           Endpoint ID as resolved in the endpoint registry at the time this event was generated.
     *           This is stored on the event and used internally by the server in case the endpoint is renamed from the time the
     *           event was originally scheduled.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\History\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Endpoint name, must exist in the endpoint registry.
     *
     * Generated from protobuf field <code>string endpoint = 1;</code>
     * @return string
     */
    public function getEndpoint()
    {
        return $this->endpoint;
    }

    /**
     * Endpoint name, must exist in the endpoint registry.
     *
     * Generated from protobuf field <code>string endpoint = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setEndpoint($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint = $var;

        return $this;
    }

    /**
     * Service name.
     *
     * Generated from protobuf field <code>string service = 2;</code>
     * @return string
     */
    public function getService()
    {
        return $this->service;
    }

    /**
     * Service name.
     *
     * Generated from protobuf field <code>string service = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setService($var)
    {
        GPBUtil::checkString($var, True);
        $this->service = $var;

        return $this;
    }

    /**
     * Operation name.
     *
     * Generated from protobuf field <code>string operation = 3;</code>
     * @return string
     */
    public function getOperation()
    {
        return $this->operation;
    }

    /**
     * Operation name.
     *
     * Generated from protobuf field <code>string operation = 3;</code>
     * @param string $var
     * @return $this
     */
    public function setOperation($var)
    {
        GPBUtil::checkString($var, True);
        $this->operation = $var;

        return $this;
    }

    /**
     * Input for the operation. The server converts this into Nexus request content and the appropriate content headers
     * internally when sending the StartOperation request. On the handler side, if it is also backed by Temporal, the
     * content is transformed back to the original Payload stored in this event.
     *
     * Generated from protobuf field <code>.temporal.api.common.v1.Payload input = 4;</code>
     * @return \Temporal\Api\Common\V1\Payload|null
     */
    public function getInput()
    {
        return $this->input;
    }

    public function hasInput()
    {
        return isset($this->input);
    }

    public function clearInput()
    {
        unset($this->input);
    }

    /**
     * Input for the operation. The server converts this into Nexus request content and the appropriate content headers
     * internally when sending the StartOperation request. On the handler side, if it is also backed by Temporal, the
     * content is transformed back to the original Payload stored in this event.
     *
     * Generated from protobuf field <code>.temporal.api.common.v1.Payload input = 4;</code>
     * @param \Temporal\Api\Common\V1\Payload $var
     * @return $this
     */
    public function setInput($var)
    {
        GPBUtil::checkMessage($var, \Temporal\Api\Common\V1\Payload::class);
        $this->input = $var;

        return $this;
    }

    /**
     * Schedule-to-close timeout for this operation.
     * Indicates how long the caller is willing to wait for operation completion.
     * Calls are retried internally by the server.
     * (-- api-linter: core::0140::prepositions=disabled
     *     aip.dev/not-precedent: "to" is used to indicate interval. --)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration schedule_to_close_timeout = 5;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getScheduleToCloseTimeout()
    {
        return $this->schedule_to_close_timeout;
    }

    public function hasScheduleToCloseTimeout()
    {
        return isset($this->schedule_to_close_timeout);
    }

    public function clearScheduleToCloseTimeout()
    {
        unset($this->schedule_to_close_timeout);
    }

    /**
     * Schedule-to-close timeout for this operation.
     * Indicates how long the caller is willing to wait for operation completion.
     * Calls are retried internally by the server.
     * (-- api-linter: core::0140::prepositions=disabled
     *     aip.dev/not-precedent: "to" is used to indicate interval. --)
     *
     * Generated from protobuf field <code>.google.protobuf.Duration schedule_to_close_timeout = 5;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setScheduleToCloseTimeout($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->schedule_to_close_timeout = $var;

        return $this;
    }

    /**
     * Header to attach to the Nexus request. Note these headers are not the same as Temporal headers on internal
     * activities and child workflows, these are transmitted to Nexus operations that may be external and are not
     * traditional payloads.
     *
     * Generated from protobuf field <code>map<string, string> nexus_header = 6;</code>
     * @return \Google\Protobuf\Internal\MapField
     */
    public function getNexusHeader()
    {
        return $this->nexus_header;
    }

    /**
     * Header to attach to the Nexus request. Note these headers are not the same as Temporal headers on internal
     * activities and child workflows, these are transmitted to Nexus operations that may be external and are not
     * traditional payloads.
     *
     * Generated from protobuf field <code>map<string, string> nexus_header = 6;</code>
     * @param array|\Google\Protobuf\Internal\MapField $var
     * @return $this
     */
    public function setNexusHeader($var)
    {
        $arr = GPBUtil::checkMapField($var, \Google\Protobuf\Internal\GPBType::STRING, \Google\Protobuf\Internal\GPBType::STRING);
        $this->nexus_header = $arr;

        return $this;
    }

    /**
     * The `WORKFLOW_TASK_COMPLETED` event that the corresponding ScheduleNexusOperation command was reported with.
     *
     * Generated from protobuf field <code>int64 workflow_task_completed_event_id = 7;</code>
     * @return int|string
     */
    public function getWorkflowTaskCompletedEventId()
    {
        return $this->workflow_task_completed_event_id;
    }

    /**
     * The `WORKFLOW_TASK_COMPLETED` event that the corresponding ScheduleNexusOperation command was reported with.
     *
     * Generated from protobuf field <code>int64 workflow_task_completed_event_id = 7;</code>
     * @param int|string $var
     * @return $this
     */
    public function setWorkflowTaskCompletedEventId($var)
    {
        GPBUtil::checkInt64($var);
        $this->workflow_task_completed_event_id = $var;

        return $this;
    }

    /**
     * A unique ID generated by the history service upon creation of this event.
     * The ID will be transmitted with all nexus StartOperation requests and is used as an idempotentency key.
     *
     * Generated from protobuf field <code>string request_id = 8;</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * A unique ID generated by the history service upon creation of this event.
     * The ID will be transmitted with all nexus StartOperation requests and is used as an idempotentency key.
     *
     * Generated from protobuf field <code>string request_id = 8;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * Endpoint ID as resolved in the endpoint registry at the time this event was generated.
     * This is stored on the event and used internally by the server in case the endpoint is renamed from the time the
     * event was originally scheduled.
     *
     * Generated from protobuf field <code>string endpoint_id = 9;</code>
     * @return string
     */
    public function getEndpointId()
    {
        return $this->endpoint_id;
    }

    /**
     * Endpoint ID as resolved in the endpoint registry at the time this event was generated.
     * This is stored on the event and used internally by the server in case the endpoint is renamed from the time the
     * event was originally scheduled.
     *
     * Generated from protobuf field <code>string endpoint_id = 9;</code>
     * @param string $var
     * @return $this
     */
    public function setEndpointId($var)
    {
        GPBUtil::checkString($var, True);
        $this->endpoint_id = $var;

        return $this;
    }

}

