<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/history/v1/message.proto

namespace Temporal\Api\History\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * Event marking an asynchronous operation was started by the responding Nexus handler.
 * If the operation completes synchronously, this event is not generated.
 * In rare situations, such as request timeouts, the service may fail to record the actual start time and will fabricate
 * this event upon receiving the operation completion via callback.
 *
 * Generated from protobuf message <code>temporal.api.history.v1.NexusOperationStartedEventAttributes</code>
 */
class NexusOperationStartedEventAttributes extends \Google\Protobuf\Internal\Message
{
    /**
     * The ID of the `NEXUS_OPERATION_SCHEDULED` event this task corresponds to.
     *
     * Generated from protobuf field <code>int64 scheduled_event_id = 1;</code>
     */
    protected $scheduled_event_id = 0;
    /**
     * The operation ID returned by the Nexus handler in the response to the StartOperation request.
     * This ID is used when canceling the operation.
     * Deprecated: Renamed to operation_token.
     *
     * Generated from protobuf field <code>string operation_id = 3 [deprecated = true];</code>
     * @deprecated
     */
    protected $operation_id = '';
    /**
     * The request ID allocated at schedule time.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     */
    protected $request_id = '';
    /**
     * The operation token returned by the Nexus handler in the response to the StartOperation request.
     * This token is used when canceling the operation.
     *
     * Generated from protobuf field <code>string operation_token = 5;</code>
     */
    protected $operation_token = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $scheduled_event_id
     *           The ID of the `NEXUS_OPERATION_SCHEDULED` event this task corresponds to.
     *     @type string $operation_id
     *           The operation ID returned by the Nexus handler in the response to the StartOperation request.
     *           This ID is used when canceling the operation.
     *           Deprecated: Renamed to operation_token.
     *     @type string $request_id
     *           The request ID allocated at schedule time.
     *     @type string $operation_token
     *           The operation token returned by the Nexus handler in the response to the StartOperation request.
     *           This token is used when canceling the operation.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\History\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * The ID of the `NEXUS_OPERATION_SCHEDULED` event this task corresponds to.
     *
     * Generated from protobuf field <code>int64 scheduled_event_id = 1;</code>
     * @return int|string
     */
    public function getScheduledEventId()
    {
        return $this->scheduled_event_id;
    }

    /**
     * The ID of the `NEXUS_OPERATION_SCHEDULED` event this task corresponds to.
     *
     * Generated from protobuf field <code>int64 scheduled_event_id = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setScheduledEventId($var)
    {
        GPBUtil::checkInt64($var);
        $this->scheduled_event_id = $var;

        return $this;
    }

    /**
     * The operation ID returned by the Nexus handler in the response to the StartOperation request.
     * This ID is used when canceling the operation.
     * Deprecated: Renamed to operation_token.
     *
     * Generated from protobuf field <code>string operation_id = 3 [deprecated = true];</code>
     * @return string
     * @deprecated
     */
    public function getOperationId()
    {
        if ($this->operation_id !== '') {
            @trigger_error('operation_id is deprecated.', E_USER_DEPRECATED);
        }
        return $this->operation_id;
    }

    /**
     * The operation ID returned by the Nexus handler in the response to the StartOperation request.
     * This ID is used when canceling the operation.
     * Deprecated: Renamed to operation_token.
     *
     * Generated from protobuf field <code>string operation_id = 3 [deprecated = true];</code>
     * @param string $var
     * @return $this
     * @deprecated
     */
    public function setOperationId($var)
    {
        @trigger_error('operation_id is deprecated.', E_USER_DEPRECATED);
        GPBUtil::checkString($var, True);
        $this->operation_id = $var;

        return $this;
    }

    /**
     * The request ID allocated at schedule time.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     * @return string
     */
    public function getRequestId()
    {
        return $this->request_id;
    }

    /**
     * The request ID allocated at schedule time.
     *
     * Generated from protobuf field <code>string request_id = 4;</code>
     * @param string $var
     * @return $this
     */
    public function setRequestId($var)
    {
        GPBUtil::checkString($var, True);
        $this->request_id = $var;

        return $this;
    }

    /**
     * The operation token returned by the Nexus handler in the response to the StartOperation request.
     * This token is used when canceling the operation.
     *
     * Generated from protobuf field <code>string operation_token = 5;</code>
     * @return string
     */
    public function getOperationToken()
    {
        return $this->operation_token;
    }

    /**
     * The operation token returned by the Nexus handler in the response to the StartOperation request.
     * This token is used when canceling the operation.
     *
     * Generated from protobuf field <code>string operation_token = 5;</code>
     * @param string $var
     * @return $this
     */
    public function setOperationToken($var)
    {
        GPBUtil::checkString($var, True);
        $this->operation_token = $var;

        return $this;
    }

}

