<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/taskqueue/v1/message.proto

namespace Temporal\Api\Taskqueue\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * These rules apply to tasks assigned to a particular Build ID
 * (`source_build_id`) to redirect them to another *compatible* Build ID
 * (`target_build_id`).
 * It is user's responsibility to ensure that the target Build ID is compatible
 * with the source Build ID (e.g. by using the Patching API).
 * Most deployments are not expected to need these rules, however following
 * situations can greatly benefit from redirects:
 *  - Need to move long-running Workflow Executions from an old Build ID to a
 *    newer one.
 *  - Need to hotfix some broken or stuck Workflow Executions.
 * In steady state, redirect rules are beneficial when dealing with old
 * Executions ran on now-decommissioned Build IDs:
 *  - To redirecting the Workflow Queries to the current (compatible) Build ID.
 *  - To be able to Reset an old Execution so it can run on the current
 *    (compatible) Build ID.
 * Redirect rules can be chained.
 *
 * Generated from protobuf message <code>temporal.api.taskqueue.v1.CompatibleBuildIdRedirectRule</code>
 */
class CompatibleBuildIdRedirectRule extends \Google\Protobuf\Internal\Message
{
    /**
     * Generated from protobuf field <code>string source_build_id = 1;</code>
     */
    protected $source_build_id = '';
    /**
     * Target Build ID must be compatible with the Source Build ID; that is it
     * must be able to process event histories made by the Source Build ID by
     * using [Patching](https://docs.temporal.io/workflows#patching) or other
     * means.
     *
     * Generated from protobuf field <code>string target_build_id = 2;</code>
     */
    protected $target_build_id = '';

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type string $source_build_id
     *     @type string $target_build_id
     *           Target Build ID must be compatible with the Source Build ID; that is it
     *           must be able to process event histories made by the Source Build ID by
     *           using [Patching](https://docs.temporal.io/workflows#patching) or other
     *           means.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\Taskqueue\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * Generated from protobuf field <code>string source_build_id = 1;</code>
     * @return string
     */
    public function getSourceBuildId()
    {
        return $this->source_build_id;
    }

    /**
     * Generated from protobuf field <code>string source_build_id = 1;</code>
     * @param string $var
     * @return $this
     */
    public function setSourceBuildId($var)
    {
        GPBUtil::checkString($var, True);
        $this->source_build_id = $var;

        return $this;
    }

    /**
     * Target Build ID must be compatible with the Source Build ID; that is it
     * must be able to process event histories made by the Source Build ID by
     * using [Patching](https://docs.temporal.io/workflows#patching) or other
     * means.
     *
     * Generated from protobuf field <code>string target_build_id = 2;</code>
     * @return string
     */
    public function getTargetBuildId()
    {
        return $this->target_build_id;
    }

    /**
     * Target Build ID must be compatible with the Source Build ID; that is it
     * must be able to process event histories made by the Source Build ID by
     * using [Patching](https://docs.temporal.io/workflows#patching) or other
     * means.
     *
     * Generated from protobuf field <code>string target_build_id = 2;</code>
     * @param string $var
     * @return $this
     */
    public function setTargetBuildId($var)
    {
        GPBUtil::checkString($var, True);
        $this->target_build_id = $var;

        return $this;
    }

}

