<?php
# Generated by the protocol buffer compiler.  DO NOT EDIT!
# NO CHECKED-IN PROTOBUF GENCODE
# source: temporal/api/taskqueue/v1/message.proto

namespace Temporal\Api\Taskqueue\V1;

use Google\Protobuf\Internal\GPBType;
use Google\Protobuf\Internal\GPBUtil;
use Google\Protobuf\RepeatedField;

/**
 * TaskQueueStats contains statistics about task queue backlog and activity.
 * For workflow task queue type, this result is partial because tasks sent to sticky queues are not included. Read
 * comments above each metric to understand the impact of sticky queue exclusion on that metric accuracy.
 *
 * Generated from protobuf message <code>temporal.api.taskqueue.v1.TaskQueueStats</code>
 */
class TaskQueueStats extends \Google\Protobuf\Internal\Message
{
    /**
     * The approximate number of tasks backlogged in this task queue. May count expired tasks but eventually
     * converges to the right value. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, the inaccuracy becomes less significant as the backlog size
     * grows.
     *
     * Generated from protobuf field <code>int64 approximate_backlog_count = 1;</code>
     */
    protected $approximate_backlog_count = 0;
    /**
     * Approximate age of the oldest task in the backlog based on the creation time of the task at the head of
     * the queue. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, they should not affect the result when backlog is older than
     * few seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration approximate_backlog_age = 2;</code>
     */
    protected $approximate_backlog_age = null;
    /**
     * The approximate tasks per second added to the task queue, averaging the last 30 seconds. These includes tasks
     * whether or not they were added to/dispatched from the backlog or they were dispatched immediately without going
     * to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_add_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_add_rate = 3;</code>
     */
    protected $tasks_add_rate = 0.0;
    /**
     * The approximate tasks per second dispatched from the task queue, averaging the last 30 seconds. These includes
     * tasks whether or not they were added to/dispatched from the backlog or they were dispatched immediately without
     * going to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_dispatch_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_dispatch_rate = 4;</code>
     */
    protected $tasks_dispatch_rate = 0.0;

    /**
     * Constructor.
     *
     * @param array $data {
     *     Optional. Data for populating the Message object.
     *
     *     @type int|string $approximate_backlog_count
     *           The approximate number of tasks backlogged in this task queue. May count expired tasks but eventually
     *           converges to the right value. Can be relied upon for scaling decisions.
     *           Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     *           those tasks only remain valid for a few seconds, the inaccuracy becomes less significant as the backlog size
     *           grows.
     *     @type \Google\Protobuf\Duration $approximate_backlog_age
     *           Approximate age of the oldest task in the backlog based on the creation time of the task at the head of
     *           the queue. Can be relied upon for scaling decisions.
     *           Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     *           those tasks only remain valid for a few seconds, they should not affect the result when backlog is older than
     *           few seconds.
     *     @type float $tasks_add_rate
     *           The approximate tasks per second added to the task queue, averaging the last 30 seconds. These includes tasks
     *           whether or not they were added to/dispatched from the backlog or they were dispatched immediately without going
     *           to the backlog (sync-matched).
     *           The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     *           backlog grows/shrinks.
     *           Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     *           tasks_add_rate, because:
     *           - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *             enable for activities by default in the latest SDKs.
     *           - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *             workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *             worker instance.
     *     @type float $tasks_dispatch_rate
     *           The approximate tasks per second dispatched from the task queue, averaging the last 30 seconds. These includes
     *           tasks whether or not they were added to/dispatched from the backlog or they were dispatched immediately without
     *           going to the backlog (sync-matched).
     *           The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     *           backlog grows/shrinks.
     *           Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     *           tasks_dispatch_rate, because:
     *           - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *             enable for activities by default in the latest SDKs.
     *           - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *             workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *             worker instance.
     * }
     */
    public function __construct($data = NULL) {
        \GPBMetadata\Temporal\Api\Taskqueue\V1\Message::initOnce();
        parent::__construct($data);
    }

    /**
     * The approximate number of tasks backlogged in this task queue. May count expired tasks but eventually
     * converges to the right value. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, the inaccuracy becomes less significant as the backlog size
     * grows.
     *
     * Generated from protobuf field <code>int64 approximate_backlog_count = 1;</code>
     * @return int|string
     */
    public function getApproximateBacklogCount()
    {
        return $this->approximate_backlog_count;
    }

    /**
     * The approximate number of tasks backlogged in this task queue. May count expired tasks but eventually
     * converges to the right value. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, the inaccuracy becomes less significant as the backlog size
     * grows.
     *
     * Generated from protobuf field <code>int64 approximate_backlog_count = 1;</code>
     * @param int|string $var
     * @return $this
     */
    public function setApproximateBacklogCount($var)
    {
        GPBUtil::checkInt64($var);
        $this->approximate_backlog_count = $var;

        return $this;
    }

    /**
     * Approximate age of the oldest task in the backlog based on the creation time of the task at the head of
     * the queue. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, they should not affect the result when backlog is older than
     * few seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration approximate_backlog_age = 2;</code>
     * @return \Google\Protobuf\Duration|null
     */
    public function getApproximateBacklogAge()
    {
        return $this->approximate_backlog_age;
    }

    public function hasApproximateBacklogAge()
    {
        return isset($this->approximate_backlog_age);
    }

    public function clearApproximateBacklogAge()
    {
        unset($this->approximate_backlog_age);
    }

    /**
     * Approximate age of the oldest task in the backlog based on the creation time of the task at the head of
     * the queue. Can be relied upon for scaling decisions.
     * Special note for workflow task queue type: this metric does not count sticky queue tasks. However, because
     * those tasks only remain valid for a few seconds, they should not affect the result when backlog is older than
     * few seconds.
     *
     * Generated from protobuf field <code>.google.protobuf.Duration approximate_backlog_age = 2;</code>
     * @param \Google\Protobuf\Duration $var
     * @return $this
     */
    public function setApproximateBacklogAge($var)
    {
        GPBUtil::checkMessage($var, \Google\Protobuf\Duration::class);
        $this->approximate_backlog_age = $var;

        return $this;
    }

    /**
     * The approximate tasks per second added to the task queue, averaging the last 30 seconds. These includes tasks
     * whether or not they were added to/dispatched from the backlog or they were dispatched immediately without going
     * to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_add_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_add_rate = 3;</code>
     * @return float
     */
    public function getTasksAddRate()
    {
        return $this->tasks_add_rate;
    }

    /**
     * The approximate tasks per second added to the task queue, averaging the last 30 seconds. These includes tasks
     * whether or not they were added to/dispatched from the backlog or they were dispatched immediately without going
     * to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_add_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_add_rate = 3;</code>
     * @param float $var
     * @return $this
     */
    public function setTasksAddRate($var)
    {
        GPBUtil::checkFloat($var);
        $this->tasks_add_rate = $var;

        return $this;
    }

    /**
     * The approximate tasks per second dispatched from the task queue, averaging the last 30 seconds. These includes
     * tasks whether or not they were added to/dispatched from the backlog or they were dispatched immediately without
     * going to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_dispatch_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_dispatch_rate = 4;</code>
     * @return float
     */
    public function getTasksDispatchRate()
    {
        return $this->tasks_dispatch_rate;
    }

    /**
     * The approximate tasks per second dispatched from the task queue, averaging the last 30 seconds. These includes
     * tasks whether or not they were added to/dispatched from the backlog or they were dispatched immediately without
     * going to the backlog (sync-matched).
     * The difference between `tasks_add_rate` and `tasks_dispatch_rate` is a reliable metric for the rate at which
     * backlog grows/shrinks.
     * Note: the actual tasks delivered to the workers may significantly be higher than the numbers reported by
     * tasks_dispatch_rate, because:
     * - Tasks can be sent to workers without going to the task queue. This is called Eager dispatch. Eager dispatch is
     *   enable for activities by default in the latest SDKs.
     * - Tasks going to Sticky queue are not accounted for. Note that, typically, only the first workflow task of each
     *   workflow goes to a normal queue, and the rest workflow tasks go to the Sticky queue associated with a specific
     *   worker instance.
     *
     * Generated from protobuf field <code>float tasks_dispatch_rate = 4;</code>
     * @param float $var
     * @return $this
     */
    public function setTasksDispatchRate($var)
    {
        GPBUtil::checkFloat($var);
        $this->tasks_dispatch_rate = $var;

        return $this;
    }

}

